/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.dynmap.Log;
import org.dynmap.MapType;
import org.dynmap.debug.Debug;
import org.dynmap.utils.BufferInputStream;
import org.dynmap.utils.BufferOutputStream;

public class ImageIOManager {
    public static String preUpdateCommand = null;
    public static String postUpdateCommand = null;
    private static Object imageioLock = new Object();
    private static final int MAX_WRITE_RETRIES = 6;
    private static LinkedList<BufferOutputStream> baoslist = new LinkedList();
    private static Object baos_lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferOutputStream imageIOEncode(BufferedImage img, MapType.ImageFormat fmt) {
        BufferOutputStream bos = new BufferOutputStream();
        Object object = imageioLock;
        synchronized (object) {
            try {
                ImageIO.setUseCache(false);
                if (fmt.getFileExt().equals("jpg")) {
                    WritableRaster raster = img.getRaster();
                    WritableRaster newRaster = raster.createWritableChild(0, 0, img.getWidth(), img.getHeight(), 0, 0, new int[]{0, 1, 2});
                    DirectColorModel cm = (DirectColorModel)img.getColorModel();
                    DirectColorModel newCM = new DirectColorModel(cm.getPixelSize(), cm.getRedMask(), cm.getGreenMask(), cm.getBlueMask());
                    BufferedImage rgbBuffer = new BufferedImage(newCM, newRaster, false, null);
                    ImageWriter writer = null;
                    Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
                    if (iter.hasNext()) {
                        writer = iter.next();
                    }
                    if (writer == null) {
                        Log.severe("No JPEG ENCODER - Java VM does not support JPEG encoding");
                        return null;
                    }
                    ImageWriteParam iwp = writer.getDefaultWriteParam();
                    iwp.setCompressionMode(2);
                    iwp.setCompressionQuality(fmt.getQuality());
                    ImageOutputStream ios = ImageIO.createImageOutputStream(bos);
                    writer.setOutput(ios);
                    writer.write(null, new IIOImage(rgbBuffer, null, null), iwp);
                    writer.dispose();
                    rgbBuffer.flush();
                } else {
                    ImageIO.write((RenderedImage)img, fmt.getFileExt(), bos);
                }
            }
            catch (IOException iox) {
                Log.info("Error encoding image - " + iox.getMessage());
                return null;
            }
        }
        return bos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void imageIOWrite(BufferedImage img, MapType.ImageFormat fmt, File fname) throws IOException {
        BufferOutputStream baos;
        int retrycnt = 0;
        boolean done = false;
        Object object = baos_lock;
        synchronized (object) {
            if (baoslist.isEmpty()) {
                baos = new BufferOutputStream();
            } else {
                baos = baoslist.removeFirst();
                baos.reset();
            }
        }
        object = imageioLock;
        synchronized (object) {
            ImageIO.setUseCache(false);
            if (fmt.getFileExt().equals("jpg")) {
                WritableRaster raster = img.getRaster();
                WritableRaster newRaster = raster.createWritableChild(0, 0, img.getWidth(), img.getHeight(), 0, 0, new int[]{0, 1, 2});
                DirectColorModel cm = (DirectColorModel)img.getColorModel();
                DirectColorModel newCM = new DirectColorModel(cm.getPixelSize(), cm.getRedMask(), cm.getGreenMask(), cm.getBlueMask());
                BufferedImage rgbBuffer = new BufferedImage(newCM, newRaster, false, null);
                ImageWriter writer = null;
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
                if (iter.hasNext()) {
                    writer = iter.next();
                }
                if (writer == null) {
                    Log.severe("No JPEG ENCODER - Java VM does not support JPEG encoding");
                    return;
                }
                ImageWriteParam iwp = writer.getDefaultWriteParam();
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality(fmt.getQuality());
                ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
                writer.setOutput(ios);
                writer.write(null, new IIOImage(rgbBuffer, null, null), iwp);
                writer.dispose();
                rgbBuffer.flush();
            } else {
                ImageIO.write((RenderedImage)img, fmt.getFileExt(), baos);
            }
        }
        byte[] rslt = baos.buf;
        int rsltlen = baos.len;
        File fcur = new File(fname.getPath());
        File fnew = new File(fname.getPath() + ".new");
        File fold = new File(fname.getPath() + ".old");
        while (!done) {
            RandomAccessFile f;
            block48: {
                f = null;
                f = new RandomAccessFile(fnew, "rw");
                f.write(rslt, 0, rsltlen);
                done = true;
                if (f == null) break block48;
                try {
                    f.close();
                }
                catch (IOException iox) {
                    done = false;
                }
            }
            if (!done) continue;
            if (preUpdateCommand != null && !preUpdateCommand.isEmpty()) {
                try {
                    new ProcessBuilder(preUpdateCommand, fnew.getAbsolutePath()).start().waitFor();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            fcur.renameTo(fold);
            fnew.renameTo(fname);
            fold.delete();
            if (postUpdateCommand == null || postUpdateCommand.isEmpty()) continue;
            try {
                new ProcessBuilder(postUpdateCommand, fname.getAbsolutePath()).start().waitFor();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            continue;
            catch (IOException fnfx) {
                block49: {
                    try {
                        if (retrycnt < 6) {
                            Debug.debug("Image file " + fname.getPath() + " - unable to write - retry #" + retrycnt);
                            try {
                                Thread.sleep(50 << retrycnt);
                            }
                            catch (InterruptedException ix) {
                                throw fnfx;
                            }
                            ++retrycnt;
                        } else {
                            Log.info("Image file " + fname.getPath() + " - unable to write - failed");
                            throw fnfx;
                        }
                        if (f == null) break block49;
                    }
                    catch (Throwable throwable) {
                        if (f != null) {
                            try {
                                f.close();
                            }
                            catch (IOException iox) {
                                done = false;
                            }
                        }
                        if (done) {
                            if (preUpdateCommand != null && !preUpdateCommand.isEmpty()) {
                                try {
                                    new ProcessBuilder(preUpdateCommand, fnew.getAbsolutePath()).start().waitFor();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            fcur.renameTo(fold);
                            fnew.renameTo(fname);
                            fold.delete();
                            if (postUpdateCommand != null && !postUpdateCommand.isEmpty()) {
                                try {
                                    new ProcessBuilder(postUpdateCommand, fname.getAbsolutePath()).start().waitFor();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        throw throwable;
                    }
                    try {
                        f.close();
                    }
                    catch (IOException iox) {
                        done = false;
                    }
                }
                if (!done) continue;
                if (preUpdateCommand != null && !preUpdateCommand.isEmpty()) {
                    try {
                        new ProcessBuilder(preUpdateCommand, fnew.getAbsolutePath()).start().waitFor();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                fcur.renameTo(fold);
                fnew.renameTo(fname);
                fold.delete();
                if (postUpdateCommand == null || postUpdateCommand.isEmpty()) continue;
                try {
                    new ProcessBuilder(postUpdateCommand, fname.getAbsolutePath()).start().waitFor();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Object object2 = baos_lock;
        synchronized (object2) {
            baoslist.addFirst(baos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage imageIORead(File fname) throws IOException {
        int retrycnt = 0;
        boolean done = false;
        BufferedImage img = null;
        while (!done) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(fname);
                byte[] b = new byte[(int)fname.length()];
                fis.read(b);
                fis.close();
                fis = null;
                BufferInputStream bais = new BufferInputStream(b);
                Object object = imageioLock;
                synchronized (object) {
                    ImageIO.setUseCache(false);
                    img = ImageIO.read(bais);
                }
                bais.close();
                done = true;
            }
            catch (IOException iOException) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    fis = null;
                }
            }
            if (done) continue;
            if (retrycnt < 6) {
                Debug.debug("Image file " + fname.getPath() + " - unable to write - retry #" + retrycnt);
                try {
                    Thread.sleep(50 << retrycnt);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++retrycnt;
                continue;
            }
            Log.info("Image file " + fname.getPath() + " - unable to read - failed");
            throw new IOException("Error reading image file " + fname.getPath());
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage imageIODecode(InputStream str) throws IOException {
        Object object = imageioLock;
        synchronized (object) {
            ImageIO.setUseCache(false);
            return ImageIO.read(str);
        }
    }
}

