/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.JSONUtils;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.json.simple.JSONObject;

public class DefaultHDLighting
implements HDLighting {
    private String name;

    public DefaultHDLighting(DynmapCore core, ConfigurationNode configuration) {
        this.name = (String)configuration.get("name");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void applyLighting(HDPerspectiveState ps, HDShaderState ss, Color incolor, Color[] outcolor) {
        for (int i = 0; i < outcolor.length; ++i) {
            outcolor[i].setColor(incolor);
        }
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return false;
    }

    @Override
    public boolean isNightAndDayEnabled() {
        return false;
    }

    @Override
    public boolean isSkyLightLevelNeeded() {
        return false;
    }

    @Override
    public boolean isEmittedLightLevelNeeded() {
        return false;
    }

    @Override
    public void addClientConfiguration(JSONObject mapObject) {
        JSONUtils.s(mapObject, "lighting", this.name);
        JSONUtils.s(mapObject, "nightandday", this.isNightAndDayEnabled());
    }

    @Override
    public int[] getBrightnessTable(DynmapWorld world) {
        return null;
    }
}

