/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.bukkit.DynmapPlugin;
import org.dynmap.bukkit.NewMapChunkCache;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.Polygon;
import org.dynmap.utils.TileFlags;

public class BukkitWorld
extends DynmapWorld {
    private World world = null;
    private World.Environment env;
    private boolean skylight;
    private DynmapLocation spawnloc = new DynmapLocation();

    public BukkitWorld(World w) {
        this(w.getName(), w.getMaxHeight(), w.getSeaLevel(), w.getEnvironment());
        this.setWorldLoaded(w);
        new Permission("dynmap.world." + this.getName(), "Dynmap access for world " + this.getName(), PermissionDefault.OP);
    }

    public BukkitWorld(String name, int height, int sealevel, World.Environment env) {
        super(name, height, sealevel);
        this.env = env;
        this.skylight = env == World.Environment.NORMAL;
        new Permission("dynmap.world." + this.getName(), "Dynmap access for world " + this.getName(), PermissionDefault.OP);
        switch (env) {
            case NETHER: {
                float f = 0.1f;
                for (int i = 0; i <= 15; ++i) {
                    float f1 = 1.0f - (float)i / 15.0f;
                    this.setBrightnessTableEntry(i, (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f);
                }
                break;
            }
        }
    }

    public void setWorldLoaded(World w) {
        this.world = w;
        this.env = this.world.getEnvironment();
        this.skylight = this.env == World.Environment.NORMAL;
    }

    @Override
    public void setWorldUnloaded() {
        this.getSpawnLocation();
        this.world = null;
    }

    @Override
    public boolean isNether() {
        return this.env == World.Environment.NETHER;
    }

    @Override
    public DynmapLocation getSpawnLocation() {
        if (this.world != null) {
            Location sloc = this.world.getSpawnLocation();
            this.spawnloc.x = sloc.getBlockX();
            this.spawnloc.y = sloc.getBlockY();
            this.spawnloc.z = sloc.getBlockZ();
            this.spawnloc.world = BukkitWorld.normalizeWorldName(sloc.getWorld().getName());
        }
        return this.spawnloc;
    }

    @Override
    public long getTime() {
        if (this.world != null) {
            return this.world.getTime();
        }
        return -1L;
    }

    @Override
    public boolean hasStorm() {
        if (this.world != null) {
            return this.world.hasStorm();
        }
        return false;
    }

    @Override
    public boolean isThundering() {
        if (this.world != null) {
            return this.world.isThundering();
        }
        return false;
    }

    @Override
    public boolean isLoaded() {
        return this.world != null;
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        if (this.world != null) {
            if (y >= 0 && y < this.worldheight) {
                return this.world.getBlockAt(x, y, z).getLightLevel();
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        if (this.world != null) {
            return this.world.getHighestBlockYAt(x, z);
        }
        return -1;
    }

    @Override
    public boolean canGetSkyLightLevel() {
        return this.skylight && this.world != null;
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        if (this.world != null) {
            if (y >= 0 && y < this.worldheight) {
                return this.world.getBlockAt(x, y, z).getLightFromSky();
            }
            return 15;
        }
        return -1;
    }

    @Override
    public String getEnvironment() {
        return this.env.name().toLowerCase();
    }

    @Override
    public MapChunkCache getChunkCache(List<DynmapChunk> chunks) {
        if (this.isLoaded()) {
            NewMapChunkCache c = new NewMapChunkCache();
            c.setChunks(this, chunks);
            return c;
        }
        return null;
    }

    public World getWorld() {
        return this.world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChunkMap(TileFlags map) {
        map.clear();
        if (this.world == null) {
            return -1;
        }
        int cnt = 0;
        for (Chunk c : this.world.getLoadedChunks()) {
            map.setFlag(c.getX(), c.getZ(), true);
            ++cnt;
        }
        File f = this.world.getWorldFolder();
        File regiondir = new File(f, "region");
        File[] lst = regiondir.listFiles();
        if (lst != null) {
            byte[] hdr = new byte[4096];
            for (File rf : lst) {
                String[] parts;
                if (!rf.getName().endsWith(".mca") || !(parts = rf.getName().split("\\."))[0].equals("r") && parts.length != 4) continue;
                RandomAccessFile rfile = null;
                int x = 0;
                int z = 0;
                try {
                    x = Integer.parseInt(parts[1]);
                    z = Integer.parseInt(parts[2]);
                    rfile = new RandomAccessFile(rf, "r");
                    rfile.read(hdr, 0, hdr.length);
                }
                catch (IOException iox) {
                    Arrays.fill(hdr, (byte)0);
                }
                catch (NumberFormatException nfx) {
                    Arrays.fill(hdr, (byte)0);
                }
                finally {
                    if (rfile != null) {
                        try {
                            rfile.close();
                        }
                        catch (IOException iox) {}
                    }
                }
                for (int i = 0; i < 1024; ++i) {
                    int zz;
                    int xx;
                    int v = hdr[4 * i] | hdr[4 * i + 1] | hdr[4 * i + 2] | hdr[4 * i + 3];
                    if (v == 0 || map.setFlag(xx = x << 5 | i & 0x1F, zz = z << 5 | i >> 5 & 0x1F, true)) continue;
                    ++cnt;
                }
            }
        }
        return cnt;
    }

    @Override
    public Polygon getWorldBorder() {
        return DynmapPlugin.plugin.getWorldBorder(this.world);
    }
}

